
/////////////////////////////////////////////////////////
// general parameters

//transforms

float4x4	shader_transform_world;
float4x4	shader_transform_view;
float4x4	shader_transform_proj;
float4x4	shader_transform_worldView;
float4x4	shader_transform_viewProj;
float4x4	shader_transform_worldViewProj;

//lights

float4		shader_light_position;
float4		shader_light_direction;
float4		shader_light_diffuse;
float4		shader_light_ambient;
float4		shader_light_specular;

//camera

float4 		shader_camera_eyePosition;
float4 		shader_camera_eyeVector;
float4 		shader_camera_upVector;

//material

float4		shader_material_diffuse;
float4		shader_material_ambient;
float4		shader_material_specular;
float		shader_material_eccentricity;
float		shader_material_transparency;
float		shader_material_reflectivity;

//textures

TEXTURE		shader_texture_0;
TEXTURE		shader_texture_1;
TEXTURE		shader_texture_2;
TEXTURE		shader_texture_3;
TEXTURE		shader_texture_4;
TEXTURE		shader_texture_5;
TEXTURE		shader_texture_cubemap;
TEXTURE		shader_texture_shadowmap;

//geometry

float4		shader_geometry_colour;

/////////////////////////////////////////////////////////
// unique parameters

float		g_currentTime;
float		water_rotor_ripple_opacity;

////////////////////////////////////////////////////////////////////
// structures

struct VS_INPUT
{
	float4 position		: POSITION;
	float3 normal		: NORMAL;
	float4 colour		: COLOR;
	float2 tex0			: TEXCOORD0;
};


struct VS_OUTPUT_HIGH
{
	float4 position			: POSITION;
	float4 colour			: COLOR0;
	float2 tex0				: TEXCOORD0;
	float2 alphaTexCoords	: TEXCOORD1;
};

////////////////////////////////////////////////////////////////////
//functions

VS_OUTPUT_HIGH vs_water_rotor_ripple( VS_INPUT input )
{
	VS_OUTPUT_HIGH output = (VS_OUTPUT_HIGH) 0;

	// Output the transformed position
	output.position = mul(input.position, shader_transform_world);
	output.alphaTexCoords = (float2(output.position.x+10000.0,output.position.z+10000.0)/20000.0);

	output.position = mul(output.position, shader_transform_viewProj);

	output.colour = float4(1,1,1,saturate(water_rotor_ripple_opacity));
	
	float nDistance = sqrt((input.position.x*input.position.x) + (input.position.z*input.position.z));
	
	if (nDistance > 35 || nDistance < 25)
	{
		output.colour = float4(1,1,1,0);
	}
	
	output.tex0 = input.tex0;
	output.tex0.y += g_currentTime * 0.001f;

	return output;
}

////////////////////////////////////////////////////////////

sampler sampler_colour_texture = sampler_state
{
	Texture = shader_texture_0;
};

sampler sampler_colour_mask = sampler_state
{
	Texture = shader_texture_1;
};

////////////////////////////////////////////////////////////

float4 ps_water_rotor_ripple( VS_OUTPUT_HIGH input ) : COLOR
{
	float4 nColour = input.colour * tex2D(sampler_colour_texture,input.tex0);
	nColour.a *= tex2D(sampler_colour_texture,input.alphaTexCoords).r;
	
	return nColour;
}

////////////////////////////////////////////////////////////
// techniques

technique water_rotor_ripple_11_20
{
	pass P0
	{
		VertexShader = compile vs_1_1 vs_water_rotor_ripple();	
		PixelShader = compile ps_2_0 ps_water_rotor_ripple();	
	}
}

technique water_rotor_ripple_11_00
{
	pass P0
	{
		VertexShader = compile vs_1_1 vs_water_rotor_ripple();	
	}
}

////////////////////////////////////////////////////////////
